Assets =
{
	Asset("ATLAS", "images/pickyeater_ui.xml"),
	Asset("IMAGE", "images/pickyeater_ui.tex"),
}

local function GetConfig(s,default)
	local c=GetModConfigData(s)
	if c==nil then
		c=default
	end
	if type(c)=="table" then
		c=c.option_data
	end
	return c
end

local alpha = {"a","b","c","d","e","f","g","h","i","j","k","L","m","n","o","p","q","r","s","t","u","v","w","x","y","z"}

toggle_Key = GetModConfigData("toggle_Key")
if type(toggle_Key) == "string" then
	toggle_Key = toggle_Key:lower():byte()
end
GLOBAL.Toggle_Key = alpha[toggle_Key - 96]
GLOBAL.widg_loc = GetConfig("widg_loc", 2)
GLOBAL.year_length = GetConfig("year_length", 70)
GLOBAL.picky_eater = GetConfig("picky_eater", true)

local menuShow = true
local FoodMenu = GLOBAL.require("widgets/foodMenu")

local function IsDefaultScreen()
	return GLOBAL.TheFrontEnd:GetActiveScreen().name:find("HUD") ~= nil
		and not(GLOBAL.GetPlayer().HUD:IsControllerCraftingOpen() or GLOBAL.GetPlayer().HUD:IsControllerInventoryOpen())
end

local function ToggleMenu()
	if type(GLOBAL.GetPlayer()) ~= "table" or type(GLOBAL.GetPlayer().HUD) ~= "table" then return end
	if not IsDefaultScreen() then return end

	if menuShow == true then
			controls.foodMenu:Hide()
			menuShow = false
	else
		controls.foodMenu:Show()
		menuShow = true
	end
end

local function AddEater(self)
	controls = self
	if controls then
		if controls.top_root then
			controls.foodMenu = controls.top_root:AddChild(FoodMenu())
		else 
			controls.foodMenu = controls:AddChild(FoodMenu())

		end		
	else
		return
	end
	GLOBAL.TheInput:AddKeyDownHandler(toggle_Key, ToggleMenu)
end

AddPrefabPostInit(
    "gears",
    function(inst)
        if inst.components.edible and inst.components.edible.hungervalue then
			inst.components.edible.hungervalue = 0
		end
	end
)

AddClassPostConstruct("widgets/controls", AddEater)
AddPlayerPostInit(function(inst) inst:AddComponent("pickyEater") end)

